<?php

/**
 * This is the model class for table "Budynek".
 *
 * The followings are the available columns in table 'Budynek':
 * @property double $id
 * @property string $nazwa
 * @property double $idRodzajuBudynku
 * @property double $idMapy
 * @property string $adres
 * @property string $opis
 * @property string $urlLogo
 */
class Budynek extends CActiveRecord
{
	/* fields used in grid view filtering */
	public $buildingType;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Budynek the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Budynek';
	}

	public function mapExists()
	{
		$map = Mapa::model()->findByPk($this->idMapy);
		if(empty($map))
		{
			$this->addError('idMapy', 'Mapa o podanym id nie istnieje.');
		}
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idRodzajuBudynku, idMapy', 'required'),
			array('idRodzajuBudynku, idMapy', 'numerical'),
			array('nazwa, urlLogo', 'length', 'max'=>256),
			array('adres, opis', 'length', 'max'=>4000),
			array('idMapy', 'mapExists'),

			array('id, nazwa, idRodzajuBudynku, idMapy, adres, opis, urlLogo, buildingType', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'banks'=>array(self::HAS_MANY, 'Bank', 'idBudynku'),
			'biuros'=>array(self::HAS_MANY, 'Biuro', 'idBudynku'),
			'mapa'=>array(self::BELONGS_TO, 'Mapa', 'idMapy'),
			'rodzajBudynku'=>array(self::BELONGS_TO, 'RodzajBudynku', 'idRodzajuBudynku'),
			'kampanies'=>array(self::HAS_MANY, 'Kampanie', 'idBudynku'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Budynek', 'ID'),
			'nazwa'=>Yii::t('Budynek', 'Nazwa'),
			'idRodzajuBudynku'=>Yii::t('Budynek', 'Rodzaj'),
			'idMapy'=>Yii::t('Budynek', 'Mapa'),
			'adres'=>Yii::t('Budynek', 'Adres'),
			'opis'=>Yii::t('Budynek', 'Opis'),
			'urlLogo'=>Yii::t('Budynek', 'Logo'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->with = array('rodzajBudynku');

		$criteria->compare(Yii::app()->db->quoteColumnName("t.id"), $this->id);
		$criteria->compare('LOWER("t"."nazwa")', strtolower($this->nazwa), true);
		$criteria->compare('LOWER("rodzajBudynku"."typ")', strtolower($this->idRodzajuBudynku), true);
		$criteria->compare('LOWER("mapa"."nazwaMiasta")', strtolower($this->idMapy), true);
		$criteria->compare('LOWER("t"."adres")', strtolower($this->adres), true);
		$criteria->compare('LOWER("t"."opis")', strtolower($this->opis), true);
		$criteria->compare(Yii::app()->db->quoteColumnName("urlLogo"), $this->urlLogo, true);
//		CVarDumper::dump($criteria, 10, true);
//		die();

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function getAllByType($type)
	{
		return self::model()->findAll(array(
			'join' => 'LEFT JOIN "RodzajBudynku" "rb" ON "rb"."id" = "t"."idRodzajuBudynku"',
			'condition' => '"rb"."typ" = :typ',
			'params' => array(':typ' => $type)
		));
	}
}
